<?php
class xin_model extends CI_Model {
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
		
	// is logged in to system
	public function is_logged_in($id)
	{
		$CI =& get_instance();
		$is_logged_in = $CI->session->userdata($id);
		return $is_logged_in;  
	}
	
	// generate random string
	public function generate_random_string($length = 7) {
		$characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	
	
	// get single user
	public function read_user_info($id) {
	   
		$condition = "id =" . "'" . $id . "' or id = ''";
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
		
	}
	
	public function read_company_user_info($id) {
	   
		$condition = "id =" . "'" . $id . "' or id = ''";
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
		
	}

	// get single user > by email
	public function read_user_info_byemail($email) {
		$condition = "email =" . "'" . $email . "' and (user_type_id='1' or user_type_id='4' )";
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where($condition);
		$this->db->limit(1);
		return $query = $this->db->get();
	}
	
	// get single user role info
	public function read_user_role_info($id) {
	    
		$condition = "role_id =" . "'" . $id . "'";
		$this->db->select('*');
		$this->db->from('user_roles');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		return $query->result();
	}
	
	// get setting info
	public function read_setting_info($id) {
	    
		$this->db->select('*');
		$this->db->from('system_setting');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	// get company setting info
	public function read_company_setting_info() {
		$this->db->select('*');
		$this->db->from('settings');
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	// get email template info
	public function read_email_template_info($id) {
	
		$condition = "id =" . "'" . $id . "'";
		$this->db->select('*');
		$this->db->from('email_template');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		return $query->result();
	}
	
	// get single record > db table > email template
	public function read_email_template($id) {
	
		$condition = "id =" . "'" . $id . "'";
		$this->db->select('*');
		$this->db->from('email_template');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		return $query->result();
	}
	
	// get title
	public function site_title() {
	    $this->db->select('*');
		$this->db->from('settings');
		$this->db->limit(1);
		$query = $this->db->get();
		$return=$query->result();
		return $return[0]->name;
	}
	
	// get image url
	public function image_cdn_url() {
	    if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on"){$ssl_set = "s";} else{$ssl_set = "";}
		return 'http'.$ssl_set.'://'.$_SERVER['HTTP_HOST'].'/images';
	}
	
	// get domain url
	public function domain_url() {
		if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on"){$ssl_set = "s";} else{$ssl_set = "";}
		return 'http'.$ssl_set.'://'.$_SERVER['HTTP_HOST'].'/';
	}

	//set currency sign
	public function set_date_format_js() {
		
		// get details
		$system_setting = $this->read_setting_info(1);
		// date format
		if($system_setting[0]->date_format_xi=='d-m-Y'){
			$d_format = 'dd-mm-yy';
		} else if($system_setting[0]->date_format_xi=='m-d-Y'){
			$d_format = 'mm-dd-yy';
		} else if($system_setting[0]->date_format_xi=='d-M-Y'){
			$d_format = 'dd-M-yy';
		} else if($system_setting[0]->date_format_xi=='M-d-Y'){
			$d_format = 'M-dd-yy';;
		}
		
		return $d_format;
	}
		
	//set currency sign
	public function set_date_format($date) {
		
		// get details
		$system_setting = $this->read_setting_info(1);
		// date formate
		if($system_setting[0]->date_format_xi=='d-m-Y'){
			$d_format = date("d-m-Y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='m-d-Y'){
			$d_format = date("m-d-Y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='d-M-Y'){
			$d_format = date("d-M-Y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='M-d-Y'){
			$d_format = date("M-d-Y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='F-j-Y'){
			$d_format = date("F-j-Y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='j-F-Y'){
			$d_format = date("j-F-Y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='m.d.y'){
			$d_format = date("m.d.y", strtotime($date));
		} else if($system_setting[0]->date_format_xi=='d.m.y'){
			$d_format = date("d.m.y", strtotime($date));
		} else {
			$d_format = $system_setting[0]->date_format_xi;
		}
		
		return $d_format;
	}
	
	// get all table rows 
	public function get_currency_types() {
	 	return  $query = $this->db->query("SELECT * from currencies  ");
	}
	
	// get all table rows 
	public function get_languages() {
	 	return  $query = $this->db->query("SELECT * from languages  ");
	}
	
	// get all table rows 
	public function get_cities() {
	 	return  $query = $this->db->query("SELECT * from cities  ");
	}
	
	// Function to add record in table
	public function add_currency_type($data){
		$this->db->insert('currencies', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	// get single record > db table > constant
	public function read_currency_types($id) {
		$condition = "id =" . "'" . $id . "' ";
		$this->db->select('*');
		$this->db->from('currencies');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	
	// get single record > db table > constant
	public function read_country_settings($id) {
		$condition = "id =" . "'" . $id . "' ";
		$this->db->select('*');
		$this->db->from('country_settings');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		return $query->result();
	}
	
	
	// get single company
	public function read_company_info($id) {
	
		$condition = "id =" . "'" . $id . "'";
		$this->db->select('*');
		$this->db->from('settings');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	// get single country
	 public function read_country_info($id) {
	
		$condition = "id =" . "'" . $id . "'";
		$this->db->select('*');
		$this->db->from('countries');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	// Function to update record in table
	public function update_currency_type_record($data, $id){
	    
		$condition = "id =" . "'" . $id . "' ";
		$this->db->where($condition);
		if( $this->db->update('currencies',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to update record in table
	public function update_country($data, $id){
	    
		$condition = "id =" . "'" . $id . "' ";
		$this->db->where($condition);
		if( $this->db->update('country_settings',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	
	// Function to Delete selected record from table
	public function delete_currency_type_record($id){
		$condition = "currency_id =" . "'" . $id . "'";
		$this->db->where($condition);
		$this->db->delete('currencies');
		
	}
	
	// get all currencies
	public function get_currencies() {
		$query = $this->db->query("SELECT * from currencies ");
		return $query->result();
	}
	
	// Function to update record in table > company information
	public function update_setting_info_record($data, $id){
	
		if( $this->db->update('system_setting',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	
	// Function to update record in table > company information
	public function update_system_profile($data, $id){
	
		if( $this->db->update('settings',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to add record in table
	public function add_language($data){
		$this->db->insert('languages', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	// Function to update record in table > company information
	public function update_language_info_record($data, $id){
	    
	    $condition = "id =" . "'" . $id . "' ";
		$this->db->where($condition);
		if( $this->db->update('languages',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// get single record > db table > constant
	public function read_langugaes($id) {
		$condition = "id =" . "'" . $id . "' ";
		$this->db->select('*');
		$this->db->from('languages');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		
		return $query->result();
	}
	
	// Function to Delete selected record from table
	public function delete_language_record($id){
		$condition = "id =" . "'" . $id . "'";
		$this->db->where($condition);
		$this->db->delete('languages');
		
	}
	
	// Function to add record in table
	public function add_city($data){
		$this->db->insert('xin_city', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	// Function to add record in table
	public function add_country_settings($data){
		$this->db->insert('country_settings', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	public function get_countries()
	{
	  $query = $this->db->query("SELECT * from countries");
  	  return $query->result();
	}
	
	// get single record > db table > constant
	public function read_cities($id) {
		$condition = "id =" . "'" . $id . "' ";
		$this->db->select('*');
		$this->db->from('cities');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	// get single record > db table > constant
	public function get_country($id) {
		$condition = "id =" . "'" . $id . "' ";
		$this->db->select('*');
		$this->db->from('countries');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->result();
	}
	
	
	
	// Function to update record in table > company information
	public function update_city_info_record($data, $id){
	    
	    $condition = "id =" . "'" . $id . "' ";
		$this->db->where($condition);
		if( $this->db->update('cities',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	
	public function get_footer_data() {
		$this->db->select('*');
		$this->db->from('cmspages');
		$this->db->where('type',1);
		$this->db->limit(1);
	     $query = $this->db->get();
		return $query->result();
	}
	
	
	// Function to update record in table > company information
	public function update_footer_record($data){
	    
	    $condition = "type = 1 ";
		$this->db->select('*');
		$this->db->from('cmspages');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		if ($query->num_rows() == 1) {
		    
		$this->db->where($condition);
		if( $this->db->update('cmspages',$data)) {
			return true;
		}
		}
		else
		{
		   $this->db->insert('cmspages', $data);
    		if ($this->db->affected_rows() > 0) {
    			return true;
    		}
		}		
	}
	
	
	// Function to Delete selected record from table
	public function delete_city_record($id){
		$condition = "id =" . "'" . $id . "'";
		$this->db->where($condition);
		$this->db->delete('cities');
		
	}
	
	
	// get user role > links > all
	public function user_role_resource(){
		
		// get session
		$system = $this->read_setting_info(1);
        $cookie_name = $system[0]->cookie_name;
		$session = $this->session->userdata($cookie_name);

		// get userinfo and role
		$user = $this->read_user_info($session['user_id']);
		$role_user = $this->read_user_role_info($user[0]->user_role_id);
		
		$role_resources_ids = explode(',',$role_user[0]->role_resources);
		return $role_resources_ids;
	}
	
	public function update_password_reset_data($data){
	    
	    $condition = "uid ='".$data['uid']."' ";
		$this->db->where($condition);
		$this->db->delete('password_reset');
		
	    $this->db->insert('password_reset', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	public function check_password_reset_data($code_1,$code_2) {
		$condition = "code_1 ='".$code_1."' and code_2='".$code_2."' order by id desc";
		$this->db->select('*');
		$this->db->from('password_reset');
		$this->db->where($condition);
		$this->db->limit(1);
		return $query = $this->db->get();
	}
	
	public function update_new_password($data,$user_id){
	    
	    $condition = "uid ='".$user_id."'";
		$this->db->where($condition);
		$this->db->delete('password_reset');
		
		$condition = " user_id='".$user_id."'";
		$this->db->where($condition);
		if( $this->db->update('users',$data)) {
			return true;
		} else {
			return false;
		}
		
	}
	
	// get all datas from main category
	
    public function menu_order_category()
	{  
	  $query = $this->db->query("SELECT * from categories where parent_id=0 order by menu_order asc");
  	  return $query->result();
	}
	
	public function home_order_category() {  
	    
	  $query = $this->db->query("SELECT * from categories order by home_order asc");
  	  return $query->result();
	}
	
	
    public function city_order() {
	    
    	  $query = $this->db->query("SELECT * FROM `cities` order by city_order asc");
      	  return $query->result();
	    }
	
	public function get_currency_decimal($symbol) {
	    
		$condition = "symbol =" . "'" . $symbol . "' ";
		$this->db->select('*');
		$this->db->from('currencies');
		$this->db->where($condition);
		$this->db->limit(1);
		$query = $this->db->get();
		return $result= $query->result();
	    
	}
	
	public function action_log($action_log) {
    	    
		$this->db->insert('admin_action_log', $action_log);
		if ($this->db->affected_rows() > 0) {
		return true;
		} else {
			return false;
		}
    } 
    
	public function get_cookie_name(){
		
		// get session
		$system = $this->read_setting_info(1);
        $cookie_name = $system[0]->cookie_name;
		return $cookie_name;
	}
	
	
}
?>