<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends MY_Controller {
	
	 public function __construct() {
        Parent::__construct();
		$this->load->library('session');
		$this->load->helper('form');
		$this->load->helper('url');
		$this->load->helper('html');
		$this->load->database();
		$this->load->library('form_validation');
		//load the models
		$this->load->model("Users_model");
		$this->load->model("Xin_model");
	}
	
	/*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	 public function index()
     {
         
        $cookie_name = $this->Xin_model->get_cookie_name();
		$session = $this->session->userdata($cookie_name);
		if(!empty($session)){ 
			
		} else {
			redirect('');
		}
		
        $data['title'] = $this->Xin_model->site_title();
		$setting = $this->Xin_model->read_setting_info(1);
		$setting_profile = $this->Xin_model->read_company_setting_info(1);
		
	    $data = array(
		'title' => $this->Xin_model->site_title(),
		'company_info_id' => $setting[0]->id,
		'application_name' => $setting[0]->application_name,
		'default_currency_symbol' => $setting[0]->default_currency_symbol,
		'default_currency' => $setting[0]->default_currency,
		'show_currency' => $setting[0]->show_currency,
		'currency_position' => $setting[0]->currency_position,
		'date_format_xi' => $setting[0]->date_format_xi,
		'company_name' => $setting_profile[0]->name,
		'email' => $setting_profile[0]->email,
		'email_cc' => $setting_profile[0]->email_cc,
		'email_bcc' => $setting_profile[0]->email_bcc,
		'address' => $setting_profile[0]->address,
		'city' => $setting_profile[0]->city,
		'trn' => $setting_profile[0]->trn,
		'phone' => $setting_profile[0]->phone,
		'mobile' => $setting_profile[0]->mobile,
		'country_id' => $setting_profile[0]->country,
		'whatsapp' => $setting_profile[0]->whatsapp,
		'logo' => $setting_profile[0]->logo,
		'small_logo' => $setting_profile[0]->small_logo,
		'favicon' => $setting_profile[0]->favicon,
		'website_url' => $setting_profile[0]->website_url,
		);
		
		$data['breadcrumbs'] = 'Settings';
		$data['path_url'] = 'settings';	
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('12',$role_resources_ids)) {
			if(!empty($session)){ 
			$data['subview'] = $this->load->view("settings/settings", $data, TRUE);
			$this->load->view('layout_main', $data); //page load
			} 
			else {
				redirect('');
			}
		} else {
			redirect('dashboard/');
		}
		
     }
     
     
    // Validate and update info in database
	public function system_info() {
	
		if($this->input->post('type')=='system_info') {
		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
		$id = 1;
		
		if(trim($this->input->post('default_currency_symbol'))==='') {
       		 $Return['error'] = "The quotation title field is required.";
		} 
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	    
	    $code=$this->input->post('default_currency_symbol');
	    $code_explode=explode('-',$code);
	    $defualt_code=$code_explode[1];
	    
		$data = array(
		'application_name' => $this->input->post('application_name'),
		'default_currency' => $this->input->post('default_currency_symbol'),
		'default_currency_symbol' => $defualt_code,
		'show_currency' => $this->input->post('show_currency'),
		'currency_position' => $this->input->post('currency_position'),
		'date_format_xi' => $this->input->post('date_format'),
		'cookie_name' => $this->input->post('cookie_name'),
		
		);
		//print_r($data);exit();
		$result = $this->Xin_model->update_setting_info_record($data,$id);		
		
		if ($result == TRUE) {
			$Return['result'] = 'System Configuration updated.';
		} else {
			$Return['error'] = 'Bug. Something went wrong, please try again.';
		}
		$this->output($Return);
		exit;
		}
	}
	
	
		// Validate and add info in database
	public function system_profile() {
		if($this->input->post('add_type')=='system_profile') {
		// Check validation for user input
		$company_name = $this->input->post('company_name');
		$id = '1';
		$setting_info = $this->Xin_model->read_company_setting_info();
		
		//print_r($_POST['attributes']);exit();
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
			
		/* Server side PHP input validation */
		if($company_name==='') {
			$Return['error'] = 'The Company name is required.';
		}/* Check if file uploaded..*/
		
		if($_FILES['logo']['size'] == 0) {
			$logo = $setting_info[0]->logo;
		} else {
			if(is_uploaded_file($_FILES['logo']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['logo']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["logo"]["tmp_name"];
					$bill_copy = "../uploads/system/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["logo"]["name"]);
					$newfilename = 'logo_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$logo = $newfilename;
					
					$delete_file = "../uploads/system/".$setting_info[0]->logo;
    		
            		if(file_exists($delete_file))
            		{
            		    unlink($delete_file);
            		}
            		
				} else {
					$Return['error'] = 'The Logo is required.';
				}
			}
		}
		
		
		if($_FILES['small_logo']['size'] == 0) {
			$small_logo = $setting_info[0]->small_logo;
		} else {
			if(is_uploaded_file($_FILES['small_logo']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['small_logo']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["small_logo"]["tmp_name"];
					$bill_copy = "../uploads/system/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["small_logo"]["name"]);
					$newfilename = 'small_logo_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$small_logo = $newfilename;
					
					$delete_file = "../uploads/system/".$setting_info[0]->small_logo;
    		
            		if(file_exists($delete_file))
            		{
            		    unlink($delete_file);
            		}
            		
				} else {
					$Return['error'] = 'The Small Logo is required.';
				}
			}
		}
		
		
		if($_FILES['fav_icon']['size'] == 0) {
			$fav_icon = $setting_info[0]->favicon;
		} else {
			if(is_uploaded_file($_FILES['fav_icon']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['fav_icon']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["fav_icon"]["tmp_name"];
					$bill_copy = "../uploads/system/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["fav_icon"]["name"]);
					$newfilename = 'favicon_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$fav_icon = $newfilename;
					
					if(isset($setting_info[0]->favicon))
					{
    					$delete_file = "../uploads/system/".$setting_info[0]->favicon;
        		
                		if(file_exists($delete_file))
                		{
                		    unlink($delete_file);
                		}
					}
            		
				} else {
					$Return['error'] = 'The Fav Icon is required.';
				}
			}
		}
        		
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'name' => $this->input->post('company_name'),
		'email' => $this->input->post('email'),
		'email_cc' => $this->input->post('cc_mail'),
		'email_bcc' => $this->input->post('bcc_mail'),
		'address' => $this->input->post('address'),
		'city' => $this->input->post('city'),
		'trn' => $this->input->post('trn_no'),
		'phone' => $this->input->post('phone'),
		'mobile' => $this->input->post('mobile'),
		'country' => $this->input->post('country'),
		'whatsapp' => $this->input->post('whatsapp'),
		'website_url' => $this->input->post('website_url'),
		'logo' => $logo,
		'small_logo' => $small_logo,
		'favicon' => $fav_icon,
		'created_at' => date('Y-m-d H:i:s'),
		);
		
		$result = $this->Xin_model->update_system_profile($data,$id);
		
		if ($result == TRUE) {
			$Return['result'] = 'System Profile Updated.';
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	

}
