<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends MY_Controller {
	
	 public function __construct() {
        Parent::__construct();
		$this->load->library('session');
		$this->load->helper('form');
		$this->load->helper('url');
		$this->load->helper('html');
		$this->load->database();
		$this->load->library('form_validation');
		//load the model
		$this->load->model("Xin_model");
		$this->load->model("Users_model");
	}
	
	/*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	  public function index() {
	      
	    $cookie_name = $this->Xin_model->get_cookie_name();
		$session = $this->session->userdata($cookie_name);
		if(!empty($session)){ 
			
		} else {
			redirect('');
		}

		$result = $this->Users_model->read_user_information($session['user_id']);
		
		$data = array(
			'name' => $result[0]->name,
			'user_id' => $result[0]->id,
			'employee_id' => $result[0]->id,
			'email' => $result[0]->email,
			'user_role_id' => $result[0]->user_role_id,
			'contact_no' => $result[0]->mobile_no,
			'is_active' => $result[0]->status_id,
			'title' => $this->Xin_model->site_title(),
			'profile_picture' => $result[0]->profile_picture,
			'last_login_date' => $result[0]->last_login_date,
			'last_login_ip' => $result[0]->last_login_ip,
			);
		
		$data['breadcrumbs'] = 'Profile';
		$data['path_url'] = 'profile';
		if(!empty($session)){ 
			$data['subview'] = $this->load->view("users/profile", $data, TRUE);
			$this->load->view('layout_main', $data); //page load
		} else {
			redirect('');
		}
	 }
	 	
	// Validate and update info in database // basic info
	public function user_basic_info() {
	
		if($this->input->post('type')=='basic_info') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
			
		/* Server side PHP input validation */		
		if($this->input->post('full_name')==='') {
       		 $Return['error'] = $this->lang->line('xin_employee_error_first_name');
		} else if(empty($this->input->post('email'))) {
			 $Return['error'] = $this->lang->line('xin_employee_error_email');
		} else if (!filter_var($this->input->post('email'), FILTER_VALIDATE_EMAIL)) {
			$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
		} else if(empty($this->input->post('contact_no'))) {
			 $Return['error'] = $this->lang->line('xin_employee_error_contact_number');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'name' => $this->input->post('full_name'),
		'email' => $this->input->post('email'),
		'mobile_no' => $this->input->post('contact_no'),
		);
		$id = $this->input->post('user_id');
		
		$result = $this->Users_model->basic_info($data,$id);
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_employee_basic_info_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	

     
     	// Validate and update info in database // social info
	public function profile_picture() {
	
		if($this->input->post('type')=='profile_picture') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
		$id = $this->input->post('user_id');
			
		/* Check if file uploaded..*/
		if($_FILES['p_file']['size'] == 0) {
			$Return['error'] = $this->lang->line('xin_employee_select_picture');
		} else {
			if(is_uploaded_file($_FILES['p_file']['tmp_name'])) {
					
					//checking image type
    				$allowed =  array('png','jpg','jpeg','gif');
    				$filename = $_FILES['p_file']['name'];
    				$ext = pathinfo($filename, PATHINFO_EXTENSION);
    				
    				if(in_array($ext,$allowed)){
					
					$uploadedfile = $_FILES['p_file']['tmp_name'];
                    
        			if ($ext == "jpg" || $ext == "jpeg")
        				{
        				    $src = imagecreatefromjpeg($uploadedfile);
        				}
        			  else if ($ext == "png")
        				{
        				    $src = imagecreatefrompng($uploadedfile);
        				}
        			  else
        				{
        				    $src = imagecreatefromgif($uploadedfile);
        				}
        
        			list($width, $height) = getimagesize($uploadedfile);
        			$newwidth = 250;
        			$newheight = ($height / $width) * $newwidth;
        			$tmp = imagecreatetruecolor($newwidth, $newheight);
        			imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
        			$uxi = rand(111, 999).round(microtime(true)).'.'.$ext;
                    $fname = $photo = "profile_" . $uxi;
        			$filename = "../uploads/profile/" . $photo;
        			imagejpeg($tmp, $filename, 100);
        			imagedestroy($src);
        			imagedestroy($tmp);
					
					$result2     = $this->Users_model->read_employee_information($this->input->post('user_id'));
        		    $delete_file = $result2[0]->profile_picture;
					
					//UPDATE Employee info in DB
					$data = array('profile_picture' => $fname);
					$result = $this->Users_model->profile_picture($data,$id);
					if ($result == TRUE) {
						$Return['result'] = $this->lang->line('xin_employee_picture_updated');
						$Return['img'] = $fname;
						
						if(file_exists('../uploads/profile/'.$delete_file))
    					{
    					    unlink('../uploads/profile/'.$delete_file);
    					}
					
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}
					$this->output($Return);
					exit;
					
				} else {
					$Return['error'] = $this->lang->line('xin_employee_picture_type');
				}
				}
			}
				
			if($Return['error']!=''){
				$this->output($Return);
			}
		}
	}
	 
}